* This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop e2		
program define e2, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"
global dd "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention

display "$units $dd"

quietly	{
	capture drop uni_e2*
	gen uni_e2 = $units 
	replace uni_e2 = $units - (m303_12 * $dd) `if' & m303_12<. & $units~=0 		// For all other obs
	replace uni_e2 = 0 if uni_e2 <0
	label var uni_e2 "$dd-adjusted units"

	capture drop uni_e2f 						// This flags the proportion of people who were affected by the change
	gen uni_e2f = 0 `if' 
	replace uni_e2f = 1 `if' & uni_e2 ~= $units 
		}

svy: mean $units uni_e2 `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]

end
