* This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop e1		
program define e1, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"
global dd "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention

display "$units $dd"

quietly	{
	capture drop uni_e1*
	gen uni_e1 = $units 
	replace uni_e1 = $units*(1-($dd/alcfreq)) `if' & $dd>0 & $units~=0 		// For all other obs
	replace uni_e1 = 0 if uni_e1<0
	label var uni_e1 "$dd-adjusted units"

	capture drop uni_e1f 						// This flags the proportion of people who were affected by the change
	gen uni_e1f = 0 `if' 
	replace uni_e1f = 1 `if' & uni_e1 ~= $units 
		}

svy: mean $units uni_e1 `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]

end
