* This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop dR		
program define dR, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
global age "`3'"

quietly {
	capture drop uni_dR*
	gen double uni_dR = $units
	replace uni_dR = 0   if ($units>0    & $sex==1 & $age>=19 & $age<=24)
	replace uni_dR = 0.1 if ($units>0.1  & $sex==1 & $age>=25 & $age<=34)
	replace uni_dR = 1.8 if ($units>1.8  & $sex==1 & $age>=35 & $age<=44)
	replace uni_dR = 5.1 if ($units>5.1  & $sex==1 & $age>=45 & $age<=54)
	replace uni_dR = 7.2 if ($units>7.2  & $sex==1 & $age>=55 & $age<=64)
	replace uni_dR = 8.4 if ($units>8.4  & $sex==1 & $age>=65 & $age<=74)
	replace uni_dR = 8.0 if ($units>8.0  & $sex==1 & $age>=75 & $age<=84)
	replace uni_dR = 7.7 if ($units>7.7  & $sex==1 & $age>=85)

	replace uni_dR = 0   if ($units>0    & $sex==2 & $age>=19 & $age<=34)
	replace uni_dR = 0.2 if ($units>0.2  & $sex==2 & $age>=35 & $age<=44)
	replace uni_dR = 0.5 if ($units>0.5  & $sex==2 & $age>=45 & $age<=54)
	replace uni_dR = 1.6 if ($units>1.6  & $sex==2 & $age>=55 & $age<=64)
	replace uni_dR = 2.7 if ($units>2.7  & $sex==2 & $age>=65 & $age<=74)
	replace uni_dR = 3.2 if ($units>3.2  & $sex==2 & $age>=75 & $age<=84)
	replace uni_dR = 3.1 if ($units>3.1  & $sex==2 & $age>=85)

	recode uni_dR (*=.) if $units==.

	capture drop uni_dRf 						// This flags the proportion of people who were affected by the change
	gen uni_dRf = 0 if $units<.
	replace uni_dRf = 1 if uni_dR ~= $units
	}


svy: mean $units uni_dR `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]
* svy: mean uni_dRf
* matrix cnt = e(b)
* ereturn scalar res2 = 100*cnt[1,1]

end
