** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop cR	// These are estimates code cR
program define cR, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_cR*						// This produces the main estimation results
	gen double uni_cR = $units
	replace uni_cR = 21 if ($units>21 & $sex==1)
	replace uni_cR = 14 if ($units>14 & $sex==2)
	recode uni_cR (nonmiss=.) if $units==.

	capture drop uni_cRf 						// This flags the proportion of people who were affected by the change
	gen uni_cRf = 0 if $units<.
	replace uni_cRf = 1 if uni_cR ~= $units
	}

svy: mean $units uni_cR `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]
* svy: mean uni_cRf
* matrix cnt = e(b)
* ereturn scalar res2 = 100*cnt[1,1]

end
