** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop c0	// These are estimates code c0
program define c0, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_c0*						// This produces the main estimation results
	gen double uni_c0 = $units
	replace uni_c0 = 0 if ($units>21 & $sex==1)
	replace uni_c0 = 0 if ($units>14 & $sex==2)
	recode uni_c0 (nonmiss=.) if $units==.

	capture drop uni_c0f 						// This flags the proportion of people who were affected by the change
	gen uni_c0f = 0 if $units<.
	replace uni_c0f = 1 if uni_c0 ~= $units
	}

svy: mean $units uni_c0 `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]
* svy: mean uni_c0f
* matrix cnt = e(b)
* ereturn scalar res2 = 100*cnt[1,1]

end
