** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop bR
program define bR, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_bR*
	local i = 1
	while `i'<=7	{
				gen double uni_bR`i'= alcuni`i'
				replace uni_bR`i' = 8 if (alcuni`i'>8 & $sex==1)
				replace uni_bR`i' = 6 if (alcuni`i'>6 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_bR=0
	capture replace uni_bR=0
	while `i'<=7	{
				replace uni_bR = uni_bR + uni_bR`i'
				local i = `i'+1
				}
	recode uni_bR (nonmiss=.) if $units==.
	label var uni_bR "BINGE-DRINKING: 8(m) 6(f)"

	capture drop uni_bRf 						// This flags the proportion of people who were affected by the change
	gen uni_bRf = 0 if $units<.
	replace uni_bRf = 1 if uni_bR ~= $units
	}



svy: mean $units uni_bR `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]

end
