** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop bN
program define bN, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_bN*
	local i = 1
	while `i'<=7	{
				gen double uni_bN`i'= alcuni`i'
				replace uni_bN`i' = 8 if (alcuni`i'<8 & $sex==1)
				replace uni_bN`i' = 6 if (alcuni`i'<6 & $sex==2)
				replace uni_bN`i' = 8 if (alcuni`i'>8 & $sex==1)
				replace uni_bN`i' = 6 if (alcuni`i'>6 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_bN=0
	capture replace uni_bN=0
	while `i'<=7	{
				replace uni_bN = uni_bN + uni_bN`i'
				local i = `i'+1
				}
	recode uni_bN (nonmiss=.) if $units==.
	label var uni_bN "**RAISED** TO BINGE-DRINKING: 8(m) 6(f)"

	capture drop uni_bNf 						// This flags the proportion of people who were affected by the change
	gen uni_bNf = 0 if $units<.
	replace uni_bNf = 1 if uni_bN ~= $units
	}



svy: mean $units uni_bN `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res2 = 100*(calc[1,2]-calc[1,1])/calc[1,1]
end
