** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop b0
program define b0, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_b0*
	local i = 1
	while `i'<=7	{
				gen double uni_b0`i'= alcuni`i'
				replace uni_b0`i' = 0 if (alcuni`i'>8 & $sex==1)
				replace uni_b0`i' = 0 if (alcuni`i'>6 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_b0=0
	capture replace uni_b0=0
	while `i'<=7	{
				replace uni_b0 = uni_b0 + uni_b0`i'
				local i = `i'+1
				}
	recode uni_b0 (nonmiss=.) if $units==.
	label var uni_b0 "BINGE-DRINKING TO ZERO: 8(m) 6(f)"

	capture drop uni_b0f 						// This flags the proportion of people who were affected by the change
	gen uni_b0f = 0 if $units<.
	replace uni_b0f = 1 if uni_b0 ~= $units
	}



svy: mean $units uni_b0 `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]

end
