** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop aR
program define aR, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_aR*
	local i = 1
	while `i'<=7	{
				gen double uni_aR`i'= alcuni`i'
				replace uni_aR`i' = 4 if (alcuni`i'>4 & $sex==1)
				replace uni_aR`i' = 3 if (alcuni`i'>3 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_aR=0
	capture replace uni_aR=0
	while `i'<=7	{
				replace uni_aR = uni_aR + uni_aR`i'
				local i = `i'+1
				}
	recode uni_aR (nonmiss=.) if $units==.
	label var uni_aR "DAILY LIMITS: 4(m) 3(f)"

	capture drop uni_aRf 						// This flags the proportion of people who were affected by the change
	gen uni_aRf = 0 if $units<.
	replace uni_aRf = 1 if uni_aR ~= $units
	}



svy: mean $units uni_aR `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]

end
