** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop aN
program define aN, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_aN*
	local i = 1
	while `i'<=7	{
				gen double uni_aN`i'= alcuni`i'
				replace uni_aN`i' = 4 if (alcuni`i'<4 & $sex==1)
				replace uni_aN`i' = 3 if (alcuni`i'<3 & $sex==2)
				replace uni_aN`i' = 4 if (alcuni`i'>4 & $sex==1)
				replace uni_aN`i' = 3 if (alcuni`i'>3 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_aN=0
	capture replace uni_aN=0
	while `i'<=7	{
				replace uni_aN = uni_aN + uni_aN`i'
				local i = `i'+1
				}
	recode uni_aN (nonmiss=.) if $units==.
	label var uni_aN "**RAISED** TO DAILY LIMITS: 4(m) 3(f)"

	capture drop uni_aNf 						// This flags the proportion of people who were affected by the change
	gen uni_aNf = 0 if $units<.
	replace uni_aNf = 1 if uni_aN ~= $units
	}



svy: mean $units uni_aN `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res2 = 100*(calc[1,2]-calc[1,1])/calc[1,1]

end
