** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop aM
program define aM, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_aM*
	local i = 1
	while `i'<=7	{
				gen double uni_aM`i'= alcuni`i'
				replace uni_aM`i' = 4 if (alcuni`i'<4 & $sex==1)
				replace uni_aM`i' = 3 if (alcuni`i'<3 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_aM=0
	capture replace uni_aM=0
	while `i'<=7	{
				replace uni_aM = uni_aM + uni_aM`i'
				local i = `i'+1
				}
	recode uni_aM (nonmiss=.) if $units==.
	label var uni_aM "**RAISED** TO DAILY LIMITS: 4(m) 3(f)"

	capture drop uni_aMf 						// This flags the proportion of people who were affected by the change
	gen uni_aMf = 0 if $units<.
	replace uni_aMf = 1 if uni_aM ~= $units
	}



svy: mean $units uni_aM `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res2 = 100*(calc[1,2]-calc[1,1])/calc[1,1]

end
