** This program creates a Confidence Interval for the estimation of conflict of interest
* It is only done as an .ado file to enable the BOOTSTRAP command to be done on it

capture program drop a0
program define a0, eclass

syntax [varlist] [if] [in]
tokenize "`varlist'"

global units "`1'"			// Weekly consumption
global sex "`2'"				// Assumes 1 is male and 2 is female, as per statistical convention
* global age "`3'"				// So that adapting this to other datasets is faster...


quietly {
	capture drop uni_a0*
	local i = 1
	while `i'<=7	{
				gen double uni_a0`i'= alcuni`i'
				replace uni_a0`i' = 0 if (alcuni`i'>4 & $sex==1)
				replace uni_a0`i' = 0 if (alcuni`i'>3 & $sex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_a0=0
	capture replace uni_a0=0
	while `i'<=7	{
				replace uni_a0 = uni_a0 + uni_a0`i'
				local i = `i'+1
				}
	recode uni_a0 (nonmiss=.) if $units==.
	label var uni_a0 "DAILY LIMITS TO ZERO: 4(m) 3(f) "

	capture drop uni_a0f 						// This flags the proportion of people who were affected by the change
	gen uni_a0f = 0 if $units<.
	replace uni_a0f = 1 if uni_a0 ~= $units
	}



svy: mean $units uni_a0 `if' `in'
tempname calc
matrix calc = e(b)
ereturn scalar res1 = 100*(calc[1,1]-calc[1,2])/calc[1,1]

end
